> **Note**: For implementing custom library components, see the [Library Interface Contract](interfaces.md).

## Using a Library Component

The Service can be run as any component imported from the [DetectMateLibrary](https://github.com/ait-detectmate/DetectMateLibrary).
For this, ensure that the library is installed in the same activated virtual environment, where the service is installed.

### 1. Update settings

Modify `settings.yaml` to use a library component:

```yaml
component_name: new_value_detector
component_type: detectors.NewValueDetector
component_config_class: detectors.NewValueDetectorConfig
config_file: detector-config.yaml
log_level: INFO
manager_addr: ipc:///tmp/detectmate.cmd.ipc
engine_addr: ipc:///tmp/detectmate.engine.ipc
```

### 2. Create component configuration

Create `detector-config.yaml`:

```yaml
detectors:                 # Category Level
  NewValueDetector:        # Class Name Level
    auto_config: false
    method_type: new_value_detector
    params:                # Implementation Specific Level
      log_variables:
        - id: test
          template: dummy_template
          variables:
            - name: var1
              pos: 0
              params:
                threshold: 0.0
```

### 3. Start with configuration

```bash
detectmate --settings settings.yaml --config detector-config.yaml
```

### 4. Reconfigure at runtime

Create `new-config.yaml`:

```yaml
detectors:
  NewValueDetector:
    auto_config: false
    method_type: new_value_detector
    params:
      log_variables:
        - id: test
          template: dummy_template
          variables:
            - name: var1
              pos: 0
              params:
                threshold: 0.8
```

The service supports dynamic reconfiguration with two modes:

#### 1. In-memory update (default)
Changes are applied to the running service but not saved to disk. The changes will be lost when the service restarts.

```bash
detectmate-client --url 127.0.0.1:8000 reconfigure path/to/new-config.yaml
```

#### 2. Persistent update (with --persist flag)
Changes are applied to the running service AND saved to the original parameter file. The changes persist across service restarts.

```bash
detectmate-client --url 127.0.0.1:8000 reconfigure path/to/new-config.yaml --persist
```

**Note:** The `--persist` flag will overwrite the original parameter file specified in your service configuration with the new values.
